/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop;

import dev.ftb.mods.ftblibrary.snbt.SNBT;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.common.serializer.SerializerControl;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.client.SyncShopS2C;

public class ShopBase
implements INBTSerializable<CompoundTag> {
    public static ShopBase SERVER;
    public static ShopBase CLIENT;
    private final LinkedList<Runnable> saveTasks = new LinkedList();
    private final LinkedList<Runnable> deserializeTask = new LinkedList();
    private final List<ShopTab> shopTabs = new ArrayList<ShopTab>();

    public List<ShopTab> getShopTabs() {
        return this.shopTabs;
    }

    public ShopTab getShopTab(UUID uuid) {
        for (ShopTab shopTab : this.shopTabs) {
            if (!Objects.equals(shopTab.shopTabUUID, uuid)) continue;
            return shopTab;
        }
        return null;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        SerializerControl.serializeVersion(nbt);
        ListTag tagShopTabs = new ListTag();
        for (ShopTab shopTab : this.shopTabs) {
            tagShopTabs.add((Object)shopTab.serializeNBT());
        }
        nbt.m_128365_("shopTabs", (Tag)tagShopTabs);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Runnable runnable = () -> {
            this.shopTabs.clear();
            ListTag tagShopTabs = nbt.m_128437_("shopTabs", 10);
            for (int i = 0; i < tagShopTabs.size(); ++i) {
                ShopTab tab = new ShopTab(this);
                tab.deserializeNBT(tagShopTabs.m_128728_(i));
                this.shopTabs.add(tab);
            }
        };
        this.deserializeTask.add(runnable);
        Iterator runnableIterator = this.deserializeTask.iterator();
        if (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
            runnableIterator.remove();
        }
    }

    public void saveShopToFile() {
        Runnable runnable = () -> {
            try {
                SNBT.write((Path)SDMShopPaths.getFile(), (CompoundTag)this.serializeNBT());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        this.saveTasks.add(runnable);
        Iterator runnableIterator = this.saveTasks.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
            runnableIterator.remove();
        }
    }

    public void syncShop(MinecraftServer server) {
        new SyncShopS2C(this.serializeNBT()).sendToAll(server);
    }

    public void syncShop(ServerPlayer player) {
        new SyncShopS2C(this.serializeNBT()).sendTo(player);
    }

    static {
        CLIENT = new ShopBase();
    }
}

